/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfyu.meadow.Meadow;
import net.satisfyu.meadow.recipes.cheese.CheeseFormRecipe;
import net.satisfyu.meadow.recipes.cooking.CookingCauldronRecipe;
import net.satisfyu.meadow.recipes.woodcutting.WoodcuttingRecipe;

public class RecipeRegistry {
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"meadow", (ResourceKey)Registry.f_122915_);
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registry.f_122914_);
    public static final RegistrySupplier<RecipeType<WoodcuttingRecipe>> WOODCUTTING = RecipeRegistry.create("woodcutting");
    public static final RegistrySupplier<RecipeSerializer<WoodcuttingRecipe>> WOODCUTTING_SERIALIZER = RecipeRegistry.create("woodcutting", WoodcuttingRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeType<CookingCauldronRecipe>> COOKING = RecipeRegistry.create("cooking");
    public static final RegistrySupplier<RecipeSerializer<CookingCauldronRecipe>> COOKING_SERIALIZER = RecipeRegistry.create("cooking", CookingCauldronRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeType<CheeseFormRecipe>> CHEESE = RecipeRegistry.create("cheese");
    public static final RegistrySupplier<RecipeSerializer<CheeseFormRecipe>> CHEESE_SERIALIZER = RecipeRegistry.create("cheese", CheeseFormRecipe.Serializer::new);

    public static void init() {
        Meadow.LOGGER.debug("Registering Recipies for meadow");
        RECIPE_SERIALIZERS.register();
        RECIPE_TYPES.register();
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeType<T>> create(final String name) {
        Supplier<RecipeType> type = () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        };
        return RECIPE_TYPES.register(name, type);
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeSerializer<T>> create(String name, Supplier<RecipeSerializer<T>> serializer) {
        return RECIPE_SERIALIZERS.register(name, serializer);
    }
}

